#!/usr/bin/env python

#   Gimp-Python - allows the writing of Gimp plugins in Python.
#   Copyright (C) 1997  James Henstridge <james@daa.com.au>
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gimpfu import *
import subprocess
import os, sys


def plugin_main(img, drw, oldfilename, newfilename, success):
  image = img
  ofilepath = os.path.split(oldfilename)[0].strip()
  ofilenamewithextension = os.path.split(oldfilename)[1].strip()
  ofilename = os.path.splitext(ofilenamewithextension)[0].strip()
  oextension = os.path.splitext(ofilenamewithextension)[1][1:].strip()

  nfilepath = os.path.split(newfilename)[0].strip()
  nfilenamewithextension = os.path.split(newfilename)[1].strip()
  nfilename = os.path.splitext(nfilenamewithextension)[0].strip()
  nextension = os.path.splitext(nfilenamewithextension)[1][1:].strip()
  pdb.gimp_progress_set_text ("after-save...")
  pdb.gimp_progress_pulse()
#------------------------------------------------------------------------------

#  ocommand = ofilepath + " - " + ofilename + " - " + oextension 
#  pdb.gimp_message(ocommand)
#  ncommand = nfilepath + " - " + nfilename + " - " + nextension 
#  pdb.gimp_message(ncommand)
  
#  if success == 0:
#    pdb.gimp_message("error")
#  if success == 1:
#    pdb.gimp_message("success")
#  if success == 2:
#    pdb.gimp_message("cancelled")

#------------------------------------------------------------------------------
# registering plug-in. DO NOT CHANGE
register(
        "plug-in-after-save",
        "Plug-in called after image exported/saved/overwritten",
        "This plug-in is called after an image was exported/saved/overwritten\n"
        "image is valid\n"
        "Parameter:\n"
        "oldfilename: the filename, the image was loaded\n"
        "newfilename: the filename, the image was saved to\n"
        "success:\n"
        "1: loading was sucessful,\n"
        "0: loading was unsuccessful,\n"
        "2: loading was canceled",
        "Hartmut Kuhse",
        "Hartmut Kuhse",
        "2013",
        "<Image>/File/User-Exits/after save",
        "*",
        [
          (PF_STRING, "oldfilename", "old filename", ""),
          (PF_STRING, "newfilename", "filename saved", ""),
          (PF_INT32, "success", "save success", ""),
        ],
        [],
        plugin_main)

main()
