#!/usr/bin/env python

#   Gimp-Python - allows the writing of Gimp plugins in Python.
#   Copyright (C) 1997  James Henstridge <james@daa.com.au>
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gimpfu import *
import subprocess
import os, sys


def plugin_main(img, drw, pathfilename, success):
  image = img
  filepath = os.path.split(pathfilename)[0].strip()
  filenamewithextension = os.path.split(pathfilename)[1].strip()
  filename = os.path.splitext(filenamewithextension)[0].strip()
  extension = os.path.splitext(filenamewithextension)[1][1:].strip()
  pdb.gimp_progress_set_text ("after-load...")
  pdb.gimp_progress_pulse()
#-------------------------------------------------------------------------------

#  if success == 0:
#    pdb.gimp_message("error")
#  if success == 1:
#    pdb.gimp_message("success")
#  if success == 2:
#    pdb.gimp_message("cancelled")
  
#  command = filepath + " - " + filename + " - " + extension 
#  pdb.gimp_message(command)

#------------------------------------------------------------------------------
# registering plug-in. DO NOT CHANGE
register(
        "plug-in-after-load",
        "Plug-in called after image was loaded",
        "This plug-in is called after an image was loaded\n"
        "image is valid\"
        "Parameter:\n"
        "pathfilename: the complete path to the loaded image\n"
        "success:\n"
        "1: loading was sucessful,\n"
        "0: loading was unsuccessful,\n"
        "2: loading was canceled",
        "Hartmut Kuhse",
        "Hartmut Kuhse",
        "2013",
        "<Image>/File/User-Exits/after load",
        "*",
        [
          (PF_STRING, "pathfilename", "filename loaded", ""),
          (PF_INT32, "success", "save success", ""),
        ],
        [],
        plugin_main)

main()
