/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#if !defined (__GIMP_BASE_H_INSIDE__) && !defined (GIMP_BASE_COMPILATION)
#error "Only <libgimpbase/gimpbase.h> can be included directly."
#endif

#ifndef __GIMP_MEMTADATA_H__
#define __GIMP_MEMTADATA_H__

#include <gexiv2/gexiv2.h>

G_BEGIN_DECLS

typedef struct _GExiv2Metadata GimpMetadata;

GimpMetadata    *gimp_metadata_new                      (void);

GExiv2Metadata  *gimp_metadata_deserialize         (const gchar      *metadata_xml);

gchar           *gimp_metadata_serialize           (GExiv2Metadata   *metadata);

GimpMetadata    *gimp_metadata_duplicate           (GimpMetadata     *metadata);

G_END_DECLS

#endif  /* __GIMP_METADATA_H__ */
