/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpmetadata.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_METADATA_H__
#define __GIMP_METADATA_H__

#include <gexiv2/gexiv2.h>

G_BEGIN_DECLS

#define TAG_LINE_DELIMITER "\v"
#define TAG_TAG_DELIMITER  "#"

typedef struct _GimpImageMetadata GimpImageMetadata;

struct _GimpImageMetadata
{
  gchar *tag;
  gchar *value;
};

/* For information look into the C source or the html documentation */
GExiv2Metadata *gimp_image_get_metadata (gint32          image_ID);

gboolean        gimp_image_set_metadata (gint32          image_ID,
                                         GExiv2Metadata *metadata);

G_END_DECLS

#endif /* __GIMP_METADATA_H__ */
