#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Export to SMF forum gallery (gimpuj.info) functionality
# and localisation support.
# Copyright (C) 2009 Siraiye and Ziomioslaw
# http://www.gimpuj.info
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

class Lang_pl_PL:
    """
    Class managing Polish localisation.
    """
    
    langDict = {
                u'English' : u'English',
                u'Polski' : u'Polski',
                u'Exception: ' : u'Wystąpił wyjątek: ',
                u'Gimpuj exception: ' : u'Gimpuj - wystąpił wyjątek: ',
                u'Upload exception: ' : u'Wystąpił wyjątek podczas wysyłania: ',
                u'Gimpuj import exception: ' : u'Gimpuj - błąd importu: ',
                u'Language:' : u'Język:',
                u'Remember choice' : u'Zapamiętaj wybór',
                u'Albums' : u'Kategoria',
                u'Title' : u'Nazwa',
                u'Description' : u'Komentarz Autora',
                u'Tags' : u'Słowa kluczowe',
                u'License' : u'Licencja',
                u'Upload' : u'Załaduj',
                u'Quit' : u'Wyjdź',
                u'Sign out' : u'Wyloguj się',
                u'Login to your gimpuj.info account' : u'Zaloguj się na gimpuj.info',
                u'Username' : u'Login',
                u'Password' : u'Hasło',
                u'Login' : u'Zaloguj się',
                u'Cancel' : u'Anuluj',
                u'Remember username' : u'Zapamiętaj login',
                u'Remember password' : u'Zapamiętaj hasło',
                u'The password will not be stored in plain text, '
                u'however it is possible for a knowledgeable person to decrypt it.' : 
                    u'Hasło będzie przechowywane w postaci zaszyfrowanej, ale mimo to '
                    u'będzie możliwe odszyfrowanie go przez niepowołane osoby.',
                u'Please save the image before publishing.' : u'Musisz zapisać obrazek przed wysłaniem.',
                u'You have to save the file in jpeg, png or gif format before publishing.' :
                    u'Przed wysłaniem musisz zapisać formacie w jpeg, png lub gif.',
                u'Your system seems to be missing following modules. Please install them before proceeding further.' :
                    u'Twój system nie posiada poniższych modułów. Zainstaluj je przed dalszym postępowaniem.',
                u'Character not accepted: ' : u'Nieprawidłowy znak: ',
                u'Login error: ' : u'Błąd logowania: ',
                u'gimpuj.info doesn\'t support uploading photos without an album. '
                    u'If you don\'t have any album already, create one at gimpuj.info.' :
                    u'gimpuj.info nie pozwala na wysyłanie obrazków bez przypisanej kategorii. '
                    u'Stwórz jakąś, jeśli nie masz żadnej.',
                u'There is no such album. Create one at gimpuj.info and try to publish picture again.' :
                    u'Nie ma takiego albumu. Stwórz go na gimpuj.info i spróbuj załadować obrazek ponownie.',
                u'Title cannot be empty' : u'Nazwa nie może być pusta',
                u'Upload of Image %d of %d failed' : u'Załadowanie obrazka %d z %d nie powiodło się',
                u'Successful upload to gimpuj.info!' : u'Udało się załadować obrazek na gimpuj.info!',
                u'Wrong username or password.' : u'Nieprawidłowa nazwa użytkownika lub hasło.',
                u'Upload failed.' : u'Załadowanie obrazka nie powiodło się.'
               }

    def getTxt(self, txt):
        """
        Method returning Polish translation for given text.
        """
        if txt not in self.langDict:
            return txt
        return self.langDict[txt]
        
class Lang_en_US:
    """
    Class managing English localisation.
    """
    def getTxt(self, txt):
        """
        Method returning English translation for given text.
        """
        return txt;

class LangGiver:
    """
    Singleton class for language settings.
    """
    
    instance = None
    
    def __init__(self):
        self.lang = Lang_en_US()
        
    @staticmethod
    def getInstance():
        if not LangGiver.instance:
            LangGiver.instance = LangGiver()
        return LangGiver.instance

def changeLanguage(language):
    """
    Main method setting the language.
    """
    if language == 'pl_PL':
        LangGiver.getInstance().lang = Lang_pl_PL()
    else:
        LangGiver.getInstance().lang = Lang_en_US()

def __(txt):
    """
    Method returning localised text.
    """
    return LangGiver.getInstance().lang.getTxt(txt)
