#!/usr/bin/env python

# Gimp publishr plugin to publish images on web
# Copyright (C) 2007  Jayesh Salvi 
# http://www.altcanvas.com
#
# Export to SMF forum gallery (gimpuj.info) functionality
# and localisation support.
# Copyright (C) 2009 Siraiye and Ziomioslaw
# http://www.gimpuj.info
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import gtk
import libpub
import libpub.gui as gui
from libpub.gimpuj import GimpujException
from libpub.lang import __, changeLanguage

######################################################
# Control
######################################################
class Control:
    '''
        @summary: This class contains the logic of high level program flow
         - Entry point to the application
         - Callback handlers that respond to user input events
    '''
    def __init__(self,window):
        self.window = window
        self.gimpujSite = 'http://www.gimpuj.info/index.php?action='
        self.gimpujRegex = 'www\.gimpuj\.info/index\.php\?action=gallery;su=user;u='
    
    def entry(self):
        '''
            @summary: Application's entry point
        '''
        #
        # If we remember last service choice, let's skip Home screen
        #
        import libpub
        service_choice = libpub.conf.get('SERVICE_CHOICE')
        changeLanguage(libpub.conf.get('LANG_CHOICE'))
        self.gimpuj = None
        if service_choice == 'FLICKR':
            self.flickr_entry_handler(widget=None,data=None)
            return
        elif service_choice == 'PICASAWEB':
            self.picasa_entry_handler(widget=None,data=None)
            return
        elif service_choice == 'GIMPUJ':
            self.gimpuj_entry_handler(widget=None,data=None)
            return
        
        # No luck, display Home screen
        self.display_home(widget=None,data=None)
            
    def display_home(self,widget,data=None):
        '''
            @summary: Display the home screen that gives a choice between services.
        '''
        if self.gimpuj != None:
            self.gimpuj.logout()
        gui.empty_window()
        home = gui.Entry(flickr_handler=self.flickr_entry_handler,
              picasa_handler=self.picasa_entry_handler,
              gimpuj_handler=self.gimpuj_entry_handler)
        self.window.add(home)
        
    def checkLatin2(self,text):
        '''
            @summary: Function handling unicode characters not recognized by iso-8859-2 encoding.
        '''
        
        polishChars = (0x0104, 0x00D3, 0x0105, 0x00F3, 0x0106, 0x015A,
                       0x0107, 0x015B, 0x0118, 0x0179, 0x0119, 0x017A,
                       0x0141, 0x017B, 0x0142, 0x017C, 0x0143, 0x0144)
        otherChars = (0xB5, 0xF0, 0xFE, 0xB9, 0xB2, 0xB3, 0xBC, 0xBD, 0xBE)
              
        for ch in unicode(text):
            num = ord(ch)
            if num in polishChars or num == 0xA:
                pass
            elif (num > 0x00 and num < 0x20) or (num > 0x7E and num < 0xA0) or num > 0xFF or num in otherChars:
                raise GimpujException, __("Character not accepted: ") + ch
    
    def flickr_entry_handler(self,widget,data=None):
        '''
            @summary: This is called when user chooses to use Flickr.
            
            If we find a saved flickr token:
                proceed straight to upload dialog
            else
                prompt for flickr login information
        '''
        import libpub
        entry = data
        if entry: 
            if entry.remember_service:
                libpub.conf.set('SERVICE_CHOICE','FLICKR')
            else:
                libpub.conf.set('SERVICE_CHOICE',None)
            
        import libpub.flickr
        gui.empty_window()
        
        self.flickr = libpub.flickr.FlickrObject()
        libpub.SERVICE_CHOICE = 'FLICKR'
        
        # If authtoken is found locally, directly go to Upload dialog
        if self.flickr.has_auth():
            self.uploadDlg = gui.UploadDlg(parent=self)
            self.window.add(self.uploadDlg)
        else:
            self.flickrRegBox = gui.FlickrRegisterBox(parent=self)
            self.window.add(self.flickrRegBox)
    
    def picasa_entry_handler(self,widget,data=None):
        '''
           @summary: This is called when user chooses to use Picasaweb
        '''
        import libpub
        entry = data
        if entry:
            if entry.remember_service:
                libpub.conf.set('SERVICE_CHOICE','PICASAWEB')
            else:
                libpub.conf.set('SERVICE_CHOICE',None)
            
        import libpub.picasa
        gui.empty_window()
        
        '''
            @note: PicasawebObject constructor checks for saved username-password
            and tries a login.
            If the login is successful: we will proceed directly to Upload dialog
            
            If it fails: then Login exception will be thrown, which will be 
            handled by the "except" clause will silently handle it and login dialog 
            will be loaded
            
            If no credentials are found in the first place: then the has_auth() will
            return false. The login dialog will be shown after getting out of the try
            block
        '''
        try:
            self.picasa = libpub.picasa.PicasawebObject()
            libpub.SERVICE_CHOICE = 'PICASAWEB'
            # If authtoken is found locally, directly go to Upload dialog
            if self.picasa.has_auth():
                self.uploadDlg = gui.UploadDlg(parent=self)
                self.window.add(self.uploadDlg)
                return
        except Exception, e:
            # Login failed, show the login dialog
            pass
            
        # Either the login failed OR credentials were absent 
        self.picwebRegBox = gui.PicasawebRegisterBox(parent=self)
        self.window.add(self.picwebRegBox)
        
    def gimpuj_entry_handler(self,widget,data=None):
        '''
           @summary: This is called when user chooses to use Gimpuj
        '''
        import libpub
        entry = data
        if entry:
            if entry.remember_service:
                libpub.conf.set('SERVICE_CHOICE','GIMPUJ')
                libpub.conf.set('LANG_CHOICE', entry.lang_choice)
                changeLanguage(entry.lang_choice)
            else:
                libpub.conf.set('SERVICE_CHOICE',None)
                libpub.conf.set('LANG_CHOICE', None)
                
        libpub.conf.set('LOGINURL', self.gimpujSite + 'login2')
        libpub.conf.set('LOGOUTURL', self.gimpujSite + 'logout')
        libpub.conf.set('ADDPICURL', self.gimpujSite + 'gallery;sa=add2')
        libpub.conf.set('ADDURL', self.gimpujSite + 'gallery;su=user;sa=addcat;u=')
        libpub.conf.set('UIDURL', self.gimpujRegex)
        
        try:
            import libpub.gimpuj
        except Exception, ex:
            libpub.alert(__('Gimpuj import exception: ') + str(ex))
            return
        gui.empty_window()
        
        '''
            @note: GimpujObject constructor checks for saved username-password
            and tries a login.
            If the login is successful: we will proceed directly to Upload dialog
            
            If it fails: then Login exception will be thrown, which will be 
            handled by the "except" clause will silently handle it and login dialog 
            will be loaded
            
            If no credentials are found in the first place: then the has_auth() will
            return false. The login dialog will be shown after getting out of the try
            block
        '''
        try:
            self.gimpuj = libpub.gimpuj.GimpujObject()
            libpub.SERVICE_CHOICE = 'GIMPUJ'
            # If authtoken is found locally, directly go to Upload dialog
            if self.gimpuj.has_auth():
                self.uploadDlg = gui.UploadDlg(parent=self)
                self.window.add(self.uploadDlg)
                return
        except Exception, e:
            # Login failed, show the login dialog
            pass
            
        # Either the login failed OR credentials were absent 
        self.gimpujRegBox = gui.GimpujRegisterBox(parent=self)
        self.window.add(self.gimpujRegBox)
        
        
    def flickr_login_handler(self,widget,data=None):
        '''
            @summary: This is called after user has entered Flickr login info
        '''
        gui.empty_window()
        if self.flickr.get_authtoken():
            self.uploadDlg = gui.UploadDlg(parent=self)
            self.window.add(self.uploadDlg)
        else:
            self.window.add(self.flickrRegBox)
        
    def picasa_login_handler(self,widget,data=None):
        '''
            @summary: This is called after user has entered Picasaweb login info
        '''
        gui.empty_window()
        try:
            username = self.picwebRegBox.usernameEntry.get_text()
            password = self.picwebRegBox.passwordEntry.get_text()
            self.picasa.login(username,password)
            
            self.uploadDlg = gui.UploadDlg(parent=self)
            self.window.add(self.uploadDlg)
        
            if self.picwebRegBox.remember_user_check.get_active():
                libpub.conf.set('PICASA_LAST_USERNAME',username)
            else:
                libpub.conf.set('PICASA_LAST_USERNAME',None)
                
            if self.picwebRegBox.remember_pass_check.get_active():
                encpass = libpub.utils.encrypt(password)
                libpub.conf.set('PICASA_LAST_PASSWORD',encpass)
            else:
                libpub.conf.set('PICASA_LAST_PASSWORD',None)
                
            
        except Exception, e:
            libpub.alert('Login error: %s'%e)
            self.window.add(self.picwebRegBox)
    
    def gimpuj_login_handler(self,widget,data=None):
        '''
            @summary: This is called after user has entered Gimpuj login info
        '''
        gui.empty_window()
        try:
            username = self.gimpujRegBox.usernameEntry.get_text()
            password = self.gimpujRegBox.passwordEntry.get_text()
            self.gimpuj.login(username,password)
            
            self.uploadDlg = gui.UploadDlg(parent=self)
            self.window.add(self.uploadDlg)
        
            if self.gimpujRegBox.remember_user_check.get_active():
                libpub.conf.set('GIMPUJ_LAST_USERNAME',username)
            else:
                libpub.conf.set('GIMPUJ_LAST_USERNAME',None)
 
            if self.gimpujRegBox.remember_pass_check.get_active():
                encpass = libpub.utils.encrypt(unicode(password))
                libpub.conf.set('GIMPUJ_LAST_PASSWORD',encpass)
            else:
                libpub.conf.set('GIMPUJ_LAST_PASSWORD',None)
            
        except Exception, e:
            self.gimpuj.logout()
            libpub.alert(__('Login error: ') + str(e))
            self.window.add(self.gimpujRegBox)
    
    def upload(self,widget,data=None):
        '''
            @summary: This is final upload function
        '''
        try:
            self.title = self.uploadDlg.titleEntry.get_text()
            buffer = self.uploadDlg.descView.get_buffer()
            startiter,enditer = buffer.get_bounds()
            desc = buffer.get_text(startiter,enditer)
            tags = self.uploadDlg.tagEntry.get_text()
            
            # Get the index of chosen license 
            license_index = self.uploadDlg.licenseCombo.get_active()
                
            # Get the chosen album name
            model = self.uploadDlg.albumCombo.get_model()
            active = self.uploadDlg.albumCombo.get_active()
            if active < 0:
                curalbum = self.uploadDlg.albumCombo.get_active_text()
            else:
                curalbum = model[active][0]
                
            # Upload to Flickr
            if libpub.SERVICE_CHOICE == 'FLICKR':
                
                from libpub.flickr import FlickrException
                
                # Get license ID for chosen license
                if license_index > 0 and license_index < len(libpub.LicenseList):
                    license_id = libpub.LicenseList[license_index][0]
                else:
                    license_id = 0
                    
                try:
                    if len(libpub.filename_list) == 1:
                        # Upload the photo
                        url = self.flickr.upload(
                            filename = libpub.filename_list[0],
                            title = self.title,
                            description = desc,
                            is_public = self.uploadDlg.is_public,
                            tags = tags,
                            license_id = str(license_id),
                            photoset = curalbum)
                        if url:
                            # save the current album into config file
                            libpub.conf.set('FLICKR_LAST_PHOTOSET',curalbum)
                            libpub.conf.set('LAST_PRIVACY_CHOICE',self.uploadDlg.is_public)
                            libpub.conf.set('LAST_LICENSE_USED',license_index)
                
                            # success message
                            #libpub.alert("Image upload was successful.\n(Flickr URL: %s)"%url,
                            #         gtk.MESSAGE_INFO)
                            successDlg = gui.SuccessDialog(url)
                            successDlg.run()
                    else:
                        count = 0
                        total = len(libpub.filename_list)
                        for filename in libpub.filename_list:
                            url = self.flickr.upload(
                                filename = filename,
                                title = self.title+'(%d of %d)'%(count+1,total),
                                description = desc+'(%d of %d)'%(count+1,total),
                                is_public = self.uploadDlg.is_public,
                                tags = tags,
                                license_id = str(license_id),
                                photoset = curalbum)
                            count+=1
                            
                            if not url:
                                raise Exception('Upload of Image %d of %d failed'%
                                                (count,total))
                                
                        libpub.alert("Image upload of %d images was successful!"%total, 
                                     gtk.MESSAGE_INFO)
                    
                    
                except FlickrException, fe:
                    libpub.alert("Flickr Exception: %s"%fe)
                    
                except Exception, e:
                    libpub.alert("Upload exception: %s"%e)
                    
                
            # Upload to Picasaweb
            elif libpub.SERVICE_CHOICE == 'PICASAWEB':
                    
                from libpub.gdata.photos.service import PicasaException
                success = False
                
                if curalbum == None or curalbum.strip() == '':
                    libpub.alert('Picasaweb doesn\'t support uploading photos \
    without an album. If you don\'t have any album already, create one by typing \
    a new album name in the "Albums" entry.')
                    return
                
                if self.title == None or self.title.strip() == '':
                    libpub.alert('Title cannot be empty')
                    return
                    
                # Determine the license text
                # Ignore the blank-license index 
                if license_index > 0 and license_index < len(libpub.LicenseList)-1:
                    license_text = libpub.LicenseList[license_index][1]
                    license_url = libpub.LicenseList[license_index][2]
                    desc += '  [%s]'%(license_text)
                    
                # this is the blank-index choice, preserve it
                elif license_index == len(libpub.LicenseList):
                    pass
                
                # correct invalid values, it is possible for user entered text
                else:
                    license_index = 0
                    
                try:
                    if len(libpub.filename_list) == 1:
                        success = self.picasa.upload(
                            filename = libpub.filename_list[0], 
                            title = self.title,
                            summary = desc,
                            tags = tags,
                            album = curalbum)
                    else:
                        count = 0
                        total = len(libpub.filename_list)
                        for filename in libpub.filename_list:
                            success = self.picasa.upload(
                                filename = filename,
                                title = self.title+'(%d of %d)'%(count+1,total), 
                                summary = desc+'(%d of %d)'%(count+1,total), 
                                tags = tags,
                                album = curalbum)
                            count+=1
                            
                            if not success:
                                raise Exception('Upload of Image %d of %d failed'%
                                            (count,total))
                            
                        
                except PicasaException, pe:
                    libpub.alert('Picasa Exception: %s'%pe)
                
                except Exception, e:
                    libpub.alert('Upload exception: %s'%e)
                    
                if success:
                    # save the current album into config file
                    libpub.conf.set('PICASA_LAST_ALBUM',curalbum)
                    libpub.conf.set('LAST_LICENSE_USED',license_index)
                    libpub.alert('Successful upload to Picasaweb!',gtk.MESSAGE_INFO)
                
            # Upload to Gimpuj
            elif libpub.SERVICE_CHOICE == 'GIMPUJ':            
                success = False
                
                if curalbum == None or curalbum.strip() == '':
                    libpub.alert(__("gimpuj.info doesn't support uploading photos "
                                    "without an album. If you don't have any album already, "
                                    "create one at gimpuj.info."))
                    return
                    
                if curalbum not in self.gimpuj.categories.keys():
                    libpub.alert(__('There is no such album. Create one at gimpuj.info '
                                    'and try to publish picture again.'))
                    return
                
                if self.title == None or self.title.strip() == '':
                    libpub.alert(__('Title cannot be empty'))
                    return

                try:
                    self.checkLatin2(self.title)
                    self.checkLatin2(desc)
                    self.checkLatin2(tags)
                except GimpujException, gex:
                    libpub.alert(str(gex))
                    return

                curalbum = self.gimpuj.categories[unicode(curalbum)]
                
                # Determine the license text
                # Ignore the blank-license index 
                if license_index >= 0 and license_index < len(libpub.GimpujLicenseList):
                    desc += '\nLicencja: %s'%(libpub.GimpujLicenseList[license_index][1])
                    
                # this is the blank-index choice, preserve it
                elif license_index == len(libpub.GimpujLicenseList):
                    pass
                
                # correct invalid values, it is possible for user entered text
                else:
                    license_index = 0
                
                try:
                    if len(libpub.filename_list) == 1:
                        success = self.gimpuj.send_picture(
                            filename = libpub.filename_list[0], 
                            title = self.title,
                            description = desc,
                            keywords = tags,
                            category = curalbum)
                    else:
                        count = 0
                        total = len(libpub.filename_list)
                        for filename in libpub.filename_list:
                            success = self.gimpuj.send_picture(
                                filename = filename,
                                title = self.title+'(%d of %d)'%(count+1,total), 
                                description = desc+'(%d of %d)'%(count+1,total), 
                                keywords = tags,
                                category = curalbum)
                            count+=1
                            
                            if not success:
                                raise Exception(__('Upload of Image %d of %d failed') % (count, total))
                            
                        
                except GimpujException, ge:
                    libpub.alert(__('Gimpuj exception: ') + str(ge))
                
                except Exception, e:
                    libpub.alert(__('Upload exception: ') + str(e))
                    
                if success:
                    self.gimpuj.logout()
                    # save the current album into config file
                    libpub.conf.set('GIMPUJ_LAST_ALBUM',curalbum)
                    libpub.conf.set('LAST_LICENSE_USED',license_index)
                    libpub.alert(__('Successful upload to gimpuj.info!'),gtk.MESSAGE_INFO)
                    
            # Cleanup the GUI
            libpub.destroy()
        
        except Exception, ex:
            libpub.alert(__('Exception: ') + str(ex))
